package com.imcode.db;

import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;

public class DatasourceDatabase implements Database {

    private QueryRunner queryRunner = new QueryRunner();
    private DataSource dataSource;

    public DatasourceDatabase( DataSource dataSource ) {
        this.dataSource = dataSource;
    }

    public Object executeCommand( final DatabaseCommand databaseCommand ) throws DatabaseException {
        try {
            Connection connection = dataSource.getConnection();
            try {
                DatabaseConnection defaultDatabaseConnection = new DatabaseConnectionImpl( connection, queryRunner );
                return databaseCommand.executeOn( defaultDatabaseConnection );
            } catch( DatabaseException e ) {
                throw new DatabaseException( "Executing "+databaseCommand, e ) ;
            } finally {
                connection.close() ;
            }
        } catch ( SQLException e ) {
            throw DatabaseException.fromSQLException( null, e );
        }
    }

    private static class DatabaseConnectionImpl implements DatabaseConnection {

        private Connection connection;
        private QueryRunner queryRunner;

        private DatabaseConnectionImpl(Connection connection, QueryRunner queryRunner) {
            this.connection = connection;
            this.queryRunner = queryRunner;
        }

        public int executeUpdate(String sql, Object[] parameters) throws DatabaseException {
            try {
                return queryRunner.update(connection, sql, parameters);
            } catch (SQLException se) {
                throw DatabaseException.fromSQLException(null, se);
            }
        }

        public Number executeUpdateAndGetGeneratedKey(String sql, Object[] parameters) throws DatabaseException {
            try {
                return JdbcUtils.executeUpdateAndGetGeneratedKey(connection, sql, parameters);
            } catch (SQLException se) {
                throw DatabaseException.fromSQLException(null, se);
            }
        }

        public Object executeQuery(String sqlQuery, Object[] parameters,
                                   ResultSetHandler resultSetHandler) throws DatabaseException {
            try {
                return queryRunner.query(connection, sqlQuery, parameters, resultSetHandler);
            } catch (SQLException e) {
                throw DatabaseException.fromSQLException(null, e);
            }
        }

        public Connection getConnection() {
            return connection;
        }
    }

}
