package com.imcode.ant.tasks;

import org.apache.tools.ant.Task;
import org.apache.tools.ant.BuildException;

public class SetSystemPropertyTask extends Task {

    private String name ;
    private String value ;

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void execute() throws BuildException {
        if (null == name || null == value) {
            throw new BuildException("Both the attributes 'name' and 'value' must be set.");
        }
        
        System.setProperty(name, value) ;
    }

}
