package com.imcode.ant.tasks;

import junit.framework.*;
import com.imcode.ant.tasks.Translate;

import java.util.Properties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.Project;

public class TranslateTest extends TestCase {

    Translate translate;

    public void testTranslateUTF8Stream() throws Exception {

        Properties properties = new Properties();
        properties.setProperty("placeholder", "") ;

        translate = new Translate();
        translate.setProject(new Project());
        translate.setProperties(properties);
        translate.setStartToken("<");
        translate.setEndToken(">");
        translate.setEncoding("iso-8859-1");

        String template = "<placeholder>" ;
        ByteArrayOutputStream destStream = new ByteArrayOutputStream();
        String inputEncoding = "iso-8859-1";
        translate.translateStream(new ByteArrayInputStream(template.getBytes(inputEncoding)), destStream, new FilterSetCollection());
        String outputEncoding = "iso-8859-1";
        assertEquals("", destStream.toString(outputEncoding)) ;
    }

}
