package com.imcode.ant.tasks;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import java.io.*;
import java.util.Properties;

public class PropertiesMerge extends Task {

    private File srcFile;
    private File destFile;
    private File mergeFile;

    public void execute() throws BuildException {
        try {
            Properties source = new Properties();
            source.load( new FileInputStream( srcFile ) );
            Properties merge = new Properties();
            merge.load( new FileInputStream( mergeFile ) );
            source.putAll( merge );
            source.store( new FileOutputStream( destFile ), null);
        } catch ( IOException e ) {
            throw new BuildException( e );
        }
    }

    public void setSrcFile( File srcFile ) {
        this.srcFile = srcFile;
    }

    public void setDestFile( File destFile ) {
        this.destFile = destFile;
    }

    public void setMergeFile( File mergeFile ) {
        this.mergeFile = mergeFile;
    }
}
