-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "browser_docs"
(
    "meta_id" INT NOT NULL,
    "to_meta_id" INT NOT NULL,
    "browser_id" INT DEFAULT 0 NOT NULL,
    PRIMARY KEY ("meta_id", "to_meta_id", "browser_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "browsers"
(
    "browser_id" INT NOT NULL,
    "name" VARCHAR(50) NOT NULL,
    "user_agent" VARCHAR(50) NOT NULL,
    "value" SMALLINT DEFAULT 1 NOT NULL,
    PRIMARY KEY ("browser_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "categories"
(
    "category_id" INT NOT NULL IDENTITY (1,1) ,
    "category_type_id" INT NOT NULL,
    "name" VARCHAR(50) NOT NULL,
    "description" VARCHAR(500),
    "image" VARCHAR(255) NOT NULL,
    PRIMARY KEY ("category_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "category_types"
(
    "category_type_id" INT NOT NULL IDENTITY (1,1) ,
    "name" VARCHAR(50) NOT NULL,
    "max_choices" INT DEFAULT 0 NOT NULL,
    "inherited" BIT NOT NULL,
    PRIMARY KEY ("category_type_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "childs"
(
    "to_meta_id" INT NOT NULL,
    "manual_sort_order" INT NOT NULL,
    "tree_sort_index" VARCHAR(64) NOT NULL,
    "menu_id" INT NOT NULL,
    PRIMARY KEY ("to_meta_id", "menu_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "classification"
(
    "class_id" INT NOT NULL IDENTITY (1,1) ,
    "code" VARCHAR(30) NOT NULL,
    PRIMARY KEY ("class_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "doc_permission_sets"
(
    "meta_id" INT NOT NULL,
    "set_id" INT NOT NULL,
    "permission_id" INT NOT NULL,
    PRIMARY KEY ("meta_id", "set_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "doc_permission_sets_ex"
(
    "meta_id" INT NOT NULL,
    "set_id" INT NOT NULL,
    "permission_id" INT NOT NULL,
    "permission_data" INT NOT NULL,
    PRIMARY KEY ("meta_id", "set_id", "permission_id", "permission_data")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "doc_permissions"
(
    "permission_id" INT NOT NULL,
    "doc_type" INT NOT NULL,
    "lang_prefix" VARCHAR(3) NOT NULL,
    "description" VARCHAR(50) NOT NULL,
    PRIMARY KEY ("permission_id", "doc_type", "lang_prefix")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "doc_types"
(
    "doc_type" INT NOT NULL,
    "lang_prefix" VARCHAR(3) DEFAULT 'swe' NOT NULL,
    "type" VARCHAR(50),
    PRIMARY KEY ("doc_type", "lang_prefix")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "document_categories"
(
    "meta_id" INT NOT NULL,
    "category_id" INT NOT NULL,
    PRIMARY KEY ("meta_id", "category_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "fileupload_docs"
(
    "meta_id" INT NOT NULL,
    "variant_name" VARCHAR(100) NOT NULL,
    "filename" VARCHAR(255) NOT NULL,
    "mime" VARCHAR(50) NOT NULL,
    "created_as_image" INT NOT NULL,
    "default_variant" BIT DEFAULT 0 NOT NULL,
    PRIMARY KEY ("meta_id", "variant_name")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "frameset_docs"
(
    "meta_id" INT NOT NULL,
    "frame_set" TEXT,
    PRIMARY KEY ("meta_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "images"
(
    "meta_id" INT NOT NULL,
    "width" INT NOT NULL,
    "height" INT NOT NULL,
    "border" INT NOT NULL,
    "v_space" INT NOT NULL,
    "h_space" INT NOT NULL,
    "name" INT NOT NULL,
    "image_name" VARCHAR(40) NOT NULL,
    "target" VARCHAR(15) NOT NULL,
    "align" VARCHAR(15) NOT NULL,
    "alt_text" VARCHAR(255) NOT NULL,
    "low_scr" VARCHAR(255) NOT NULL,
    "imgurl" VARCHAR(255) NOT NULL,
    "linkurl" VARCHAR(255) NOT NULL,
    "type" INT NOT NULL,
    PRIMARY KEY ("meta_id", "name")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "includes"
(
    "meta_id" INT NOT NULL,
    "include_id" INT NOT NULL,
    "included_meta_id" INT NOT NULL,
    PRIMARY KEY ("meta_id", "include_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "ip_accesses"
(
    "ip_access_id" INT NOT NULL IDENTITY (1,1) ,
    "user_id" INT NOT NULL,
    "ip_start" DECIMAL(18,0) NOT NULL,
    "ip_end" DECIMAL(18,0) NOT NULL,
    PRIMARY KEY ("ip_access_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "lang_prefixes"
(
    "lang_id" INT NOT NULL,
    "lang_prefix" CHAR(3),
    PRIMARY KEY ("lang_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "languages"
(
    "lang_prefix" VARCHAR(3) NOT NULL,
    "user_prefix" VARCHAR(3) NOT NULL,
    "language" VARCHAR(30),
    PRIMARY KEY ("lang_prefix", "user_prefix")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "menus"
(
    "menu_id" INT NOT NULL IDENTITY (1,1) ,
    "meta_id" INT NOT NULL,
    "menu_index" INT NOT NULL,
    "sort_order" INT NOT NULL,
    PRIMARY KEY ("menu_id")
);

CREATE UNIQUE INDEX "UQ_menus__meta_id__menu_index" ON "menus" ("meta_id", "menu_index");

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "meta"
(
    "meta_id" INT NOT NULL IDENTITY (1,1) ,
    "doc_type" INT NOT NULL,
    "meta_headline" VARCHAR(255) NOT NULL,
    "meta_text" VARCHAR(1000) NOT NULL,
    "meta_image" VARCHAR(255) NOT NULL,
    "owner_id" INT NOT NULL,
    "permissions" INT NOT NULL,
    "shared" INT NOT NULL,
    "show_meta" INT NOT NULL,
    "lang_prefix" VARCHAR(3) NOT NULL,
    "date_created" DATETIME NOT NULL,
    "date_modified" DATETIME NOT NULL,
    "disable_search" INT NOT NULL,
    "target" VARCHAR(10) NOT NULL,
    "activate" INT NOT NULL,
    "archived_datetime" DATETIME,
    "publisher_id" INT,
    "status" INT NOT NULL,
    "publication_start_datetime" DATETIME,
    "publication_end_datetime" DATETIME,
    PRIMARY KEY ("meta_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "meta_classification"
(
    "meta_id" INT NOT NULL,
    "class_id" INT NOT NULL,
    PRIMARY KEY ("meta_id", "class_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "meta_section"
(
    "meta_id" INT NOT NULL,
    "section_id" INT NOT NULL,
    PRIMARY KEY ("meta_id", "section_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "mime_types"
(
    "mime_id" INT NOT NULL,
    "mime_name" VARCHAR(50) NOT NULL,
    "mime" VARCHAR(50) NOT NULL,
    "lang_prefix" VARCHAR(3) DEFAULT 'swe' NOT NULL,
    PRIMARY KEY ("mime_id", "lang_prefix")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "new_doc_permission_sets"
(
    "meta_id" INT NOT NULL,
    "set_id" INT NOT NULL,
    "permission_id" INT NOT NULL,
    PRIMARY KEY ("meta_id", "set_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "new_doc_permission_sets_ex"
(
    "meta_id" INT NOT NULL,
    "set_id" INT NOT NULL,
    "permission_id" INT NOT NULL,
    "permission_data" INT NOT NULL,
    PRIMARY KEY ("meta_id", "set_id", "permission_id", "permission_data")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "permission_sets"
(
    "set_id" INT NOT NULL,
    "description" VARCHAR(30) NOT NULL,
    PRIMARY KEY ("set_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "permissions"
(
    "permission_id" SMALLINT NOT NULL,
    "lang_prefix" VARCHAR(3) DEFAULT 'swe' NOT NULL,
    "description" VARCHAR(50) NOT NULL,
    PRIMARY KEY ("permission_id", "lang_prefix")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "phones"
(
    "phone_id" INT NOT NULL IDENTITY (1,1) ,
    "number" VARCHAR(25) NOT NULL,
    "user_id" INT NOT NULL,
    "phonetype_id" INT DEFAULT 0 NOT NULL,
    PRIMARY KEY ("phone_id", "user_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "phonetypes"
(
    "phonetype_id" INT NOT NULL,
    "typename" VARCHAR(12) NOT NULL,
    "lang_id" INT NOT NULL,
    PRIMARY KEY ("phonetype_id", "lang_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "roles"
(
    "role_id" INT NOT NULL IDENTITY (1,1) ,
    "role_name" VARCHAR(60) NOT NULL,
    "permissions" INT DEFAULT 0 NOT NULL,
    "admin_role" INT DEFAULT 0 NOT NULL,
    PRIMARY KEY ("role_id")
);

CREATE UNIQUE INDEX "UQ_roles__role_name" ON "roles" ("role_name");

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "roles_rights"
(
    "role_id" INT NOT NULL,
    "meta_id" INT NOT NULL,
    "set_id" SMALLINT NOT NULL,
    PRIMARY KEY ("role_id", "meta_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "sections"
(
    "section_id" INT NOT NULL IDENTITY (1,1) ,
    "section_name" VARCHAR(50) NOT NULL,
    PRIMARY KEY ("section_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "stats"
(
    "name" VARCHAR(120) NOT NULL,
    "num" INT NOT NULL,
    PRIMARY KEY ("name")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "sys_data"
(
    "sys_id" SMALLINT NOT NULL IDENTITY (1,1) ,
    "type_id" SMALLINT NOT NULL,
    "value" VARCHAR(1000),
    PRIMARY KEY ("sys_id", "type_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "sys_types"
(
    "type_id" SMALLINT NOT NULL,
    "name" VARCHAR(50),
    PRIMARY KEY ("type_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "templategroups"
(
    "group_id" INT NOT NULL IDENTITY (1,1) ,
    "group_name" VARCHAR(50) NOT NULL,
    PRIMARY KEY ("group_id")
);

CREATE UNIQUE INDEX "UQ_templategroups__group_name" ON "templategroups" ("group_name");

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "templates"
(
    "template_id" INT NOT NULL,
    "template_name" VARCHAR(80) NOT NULL,
    "simple_name" VARCHAR(80) NOT NULL,
    "lang_prefix" VARCHAR(3) NOT NULL,
    "no_of_txt" INT,
    "no_of_img" INT,
    "no_of_url" INT,
    PRIMARY KEY ("template_id")
);

CREATE UNIQUE INDEX "UQ_template__simple_name__lang_prefix" ON "templates" ("simple_name", "lang_prefix");

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "templates_cref"
(
    "group_id" INT NOT NULL,
    "template_id" INT NOT NULL,
    PRIMARY KEY ("group_id", "template_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "text_docs"
(
    "meta_id" INT NOT NULL,
    "template_id" INT NOT NULL,
    "group_id" INT DEFAULT 1 NOT NULL,
    "default_template_1" INT DEFAULT -1 NOT NULL,
    "default_template_2" INT DEFAULT -1 NOT NULL,
    "default_template" INT,
    PRIMARY KEY ("meta_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "texts"
(
    "meta_id" INT NOT NULL,
    "name" INT NOT NULL,
    "text" TEXT NOT NULL,
    "type" INT,
    "counter" INT NOT NULL IDENTITY (1,1) ,
    PRIMARY KEY ("counter")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "url_docs"
(
    "meta_id" INT NOT NULL,
    "frame_name" VARCHAR(80) NOT NULL,
    "target" VARCHAR(15) NOT NULL,
    "url_ref" VARCHAR(255) NOT NULL,
    "url_txt" VARCHAR(255) NOT NULL,
    "lang_prefix" VARCHAR(3) NOT NULL,
    PRIMARY KEY ("meta_id", "lang_prefix")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "user_rights"
(
    "user_id" INT NOT NULL,
    "meta_id" INT NOT NULL,
    "permission_id" SMALLINT NOT NULL,
    PRIMARY KEY ("user_id", "meta_id", "permission_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "user_roles_crossref"
(
    "user_id" INT NOT NULL,
    "role_id" INT NOT NULL,
    PRIMARY KEY ("user_id", "role_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "useradmin_role_crossref"
(
    "user_id" INT NOT NULL,
    "role_id" INT NOT NULL,
    PRIMARY KEY ("user_id", "role_id")
);

-- ----------------------------------------------------------------------- 

-- ----------------------------------------------------------------------- 

SET quoted_identifier on;

CREATE TABLE "users"
(
    "user_id" INT NOT NULL IDENTITY (1,1) ,
    "login_name" VARCHAR(50) NOT NULL,
    "login_password" VARCHAR(15) NOT NULL,
    "first_name" VARCHAR(25) NOT NULL,
    "last_name" VARCHAR(30) NOT NULL,
    "title" VARCHAR(30) NOT NULL,
    "company" VARCHAR(30) NOT NULL,
    "address" VARCHAR(40) NOT NULL,
    "city" VARCHAR(30) NOT NULL,
    "zip" VARCHAR(15) NOT NULL,
    "country" VARCHAR(30) NOT NULL,
    "county_council" VARCHAR(30) NOT NULL,
    "email" VARCHAR(50) NOT NULL,
    "external" INT NOT NULL,
    "active" INT DEFAULT 1 NOT NULL,
    "create_date" DATETIME NOT NULL,
    "language" VARCHAR(3) NOT NULL,
    PRIMARY KEY ("user_id")
);

CREATE UNIQUE INDEX "UQ__users__login_name" ON "users" ("login_name");

ALTER TABLE "browser_docs"
    ADD CONSTRAINT "browser_docs_FK_meta_id_meta" FOREIGN KEY ("meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "categories"
    ADD CONSTRAINT "categories_FK_category_type_id_category_types" FOREIGN KEY ("category_type_id") REFERENCES "category_types" ("category_type_id");

ALTER TABLE "childs"
    ADD CONSTRAINT "childs_FK_to_meta_id_meta" FOREIGN KEY ("to_meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "childs"
    ADD CONSTRAINT "childs_FK_menu_id_menus" FOREIGN KEY ("menu_id") REFERENCES "menus" ("menu_id");

ALTER TABLE "doc_permission_sets"
    ADD CONSTRAINT "doc_permission_sets_FK_set_id_permission_sets" FOREIGN KEY ("set_id") REFERENCES "permission_sets" ("set_id");

ALTER TABLE "doc_permission_sets"
    ADD CONSTRAINT "doc_permission_sets_FK_meta_id_meta" FOREIGN KEY ("meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "doc_permission_sets_ex"
    ADD CONSTRAINT "doc_permission_sets_ex_FK_set_id_permission_sets" FOREIGN KEY ("set_id") REFERENCES "permission_sets" ("set_id");

ALTER TABLE "doc_permission_sets_ex"
    ADD CONSTRAINT "doc_permission_sets_ex_FK_meta_id_set_id_doc_permission_sets" FOREIGN KEY ("meta_id", "set_id") REFERENCES "doc_permission_sets" ("meta_id", "set_id");

ALTER TABLE "document_categories"
    ADD CONSTRAINT "document_categories_FK_meta_id_meta" FOREIGN KEY ("meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "document_categories"
    ADD CONSTRAINT "document_categories_FK_category_id_categories" FOREIGN KEY ("category_id") REFERENCES "categories" ("category_id");

ALTER TABLE "frameset_docs"
    ADD CONSTRAINT "frameset_docs_FK_meta_id_meta" FOREIGN KEY ("meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "images"
    ADD CONSTRAINT "images_FK_meta_id_meta" FOREIGN KEY ("meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "includes"
    ADD CONSTRAINT "includes_FK_meta_id_meta" FOREIGN KEY ("meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "includes"
    ADD CONSTRAINT "includes_FK_included_meta_id_meta" FOREIGN KEY ("included_meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "menus"
    ADD CONSTRAINT "menus_FK_meta_id_meta" FOREIGN KEY ("meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "meta"
    ADD CONSTRAINT "meta_FK_owner_id_users" FOREIGN KEY ("owner_id") REFERENCES "users" ("user_id");

ALTER TABLE "meta"
    ADD CONSTRAINT "meta_FK_publisher_id_users" FOREIGN KEY ("publisher_id") REFERENCES "users" ("user_id");

ALTER TABLE "meta_classification"
    ADD CONSTRAINT "meta_classification_FK_meta_id_meta" FOREIGN KEY ("meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "meta_classification"
    ADD CONSTRAINT "meta_classification_FK_class_id_classification" FOREIGN KEY ("class_id") REFERENCES "classification" ("class_id");

ALTER TABLE "meta_section"
    ADD CONSTRAINT "meta_section_FK_meta_id_meta" FOREIGN KEY ("meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "meta_section"
    ADD CONSTRAINT "meta_section_FK_section_id_sections" FOREIGN KEY ("section_id") REFERENCES "sections" ("section_id");

ALTER TABLE "new_doc_permission_sets"
    ADD CONSTRAINT "new_doc_permission_sets_FK_set_id_permission_sets" FOREIGN KEY ("set_id") REFERENCES "permission_sets" ("set_id");

ALTER TABLE "new_doc_permission_sets"
    ADD CONSTRAINT "new_doc_permission_sets_FK_meta_id_meta" FOREIGN KEY ("meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "new_doc_permission_sets_ex"
    ADD CONSTRAINT "new_doc_permission_sets_ex_FK_set_id_permission_sets" FOREIGN KEY ("set_id") REFERENCES "permission_sets" ("set_id");

ALTER TABLE "new_doc_permission_sets_ex"
    ADD CONSTRAINT "new_doc_permission_sets_ex_FK_meta_id_set_id_new_doc_permission_sets" FOREIGN KEY ("meta_id", "set_id") REFERENCES "new_doc_permission_sets" ("meta_id", "set_id");

ALTER TABLE "phones"
    ADD CONSTRAINT "phones_FK_user_id_users" FOREIGN KEY ("user_id") REFERENCES "users" ("user_id");

ALTER TABLE "phonetypes"
    ADD CONSTRAINT "phonetypes_FK_lang_id_lang_prefixes" FOREIGN KEY ("lang_id") REFERENCES "lang_prefixes" ("lang_id");

ALTER TABLE "roles_rights"
    ADD CONSTRAINT "roles_rights_FK_role_id_roles" FOREIGN KEY ("role_id") REFERENCES "roles" ("role_id");

ALTER TABLE "roles_rights"
    ADD CONSTRAINT "roles_rights_FK_meta_id_meta" FOREIGN KEY ("meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "sys_data"
    ADD CONSTRAINT "sys_data_FK_type_id_sys_types" FOREIGN KEY ("type_id") REFERENCES "sys_types" ("type_id");

ALTER TABLE "templates_cref"
    ADD CONSTRAINT "templates_cref_FK_group_id_templategroups" FOREIGN KEY ("group_id") REFERENCES "templategroups" ("group_id");

ALTER TABLE "templates_cref"
    ADD CONSTRAINT "templates_cref_FK_template_id_templates" FOREIGN KEY ("template_id") REFERENCES "templates" ("template_id");

ALTER TABLE "text_docs"
    ADD CONSTRAINT "text_docs_FK_meta_id_meta" FOREIGN KEY ("meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "text_docs"
    ADD CONSTRAINT "text_docs_FK_template_id_templates" FOREIGN KEY ("template_id") REFERENCES "templates" ("template_id");

ALTER TABLE "text_docs"
    ADD CONSTRAINT "text_docs_FK_default_template_templates" FOREIGN KEY ("default_template") REFERENCES "templates" ("template_id");

ALTER TABLE "texts"
    ADD CONSTRAINT "texts_FK_meta_id_meta" FOREIGN KEY ("meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "url_docs"
    ADD CONSTRAINT "url_docs_FK_meta_id_meta" FOREIGN KEY ("meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "user_rights"
    ADD CONSTRAINT "user_rights_FK_user_id_users" FOREIGN KEY ("user_id") REFERENCES "users" ("user_id");

ALTER TABLE "user_rights"
    ADD CONSTRAINT "user_rights_FK_meta_id_meta" FOREIGN KEY ("meta_id") REFERENCES "meta" ("meta_id");

ALTER TABLE "user_roles_crossref"
    ADD CONSTRAINT "user_roles_crossref_FK_user_id_users" FOREIGN KEY ("user_id") REFERENCES "users" ("user_id");

ALTER TABLE "user_roles_crossref"
    ADD CONSTRAINT "user_roles_crossref_FK_role_id_roles" FOREIGN KEY ("role_id") REFERENCES "roles" ("role_id");

ALTER TABLE "useradmin_role_crossref"
    ADD CONSTRAINT "useradmin_role_crossref_FK_role_id_roles" FOREIGN KEY ("role_id") REFERENCES "roles" ("role_id");

ALTER TABLE "useradmin_role_crossref"
    ADD CONSTRAINT "useradmin_role_crossref_FK_user_id_users" FOREIGN KEY ("user_id") REFERENCES "users" ("user_id");



INSERT INTO languages VALUES('swe','swe','Svenska');
INSERT INTO languages VALUES('swe','eng','Swedish');
INSERT INTO languages VALUES('eng','swe','Engelska');
INSERT INTO languages VALUES('eng','eng','English');

INSERT INTO lang_prefixes VALUES(1,'swe');
INSERT INTO lang_prefixes VALUES(2,'eng');

INSERT INTO doc_types VALUES(2, 'swe', 'Textsida');
INSERT INTO doc_types VALUES(5, 'swe', 'Extern lnk');
INSERT INTO doc_types VALUES(6, 'swe', 'Browserkontroll');
INSERT INTO doc_types VALUES(7, 'swe', 'HTML-dokument');
INSERT INTO doc_types VALUES(8, 'swe', 'Fil');

INSERT INTO doc_types VALUES(2, 'eng', 'Text page');
INSERT INTO doc_types VALUES(5, 'eng', 'External link');
INSERT INTO doc_types VALUES(6, 'eng', 'Browser controlled link');
INSERT INTO doc_types VALUES(7, 'eng', 'HTML-document');
INSERT INTO doc_types VALUES(8, 'eng', 'File');

INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(65536,2,'swe','ndra text');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(65536,5,'swe','Redigera');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(65536,6,'swe','Redigera');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(65536,7,'swe','Redigera');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(65536,8,'swe','Redigera');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(65536,101,'swe','Redigera');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(65536,102,'swe','Redigera');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(131072,2,'swe','ndra bild');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(262144,2,'swe','ndra meny');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(524288,2,'swe','ndra utseende');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(1048576,2,'swe','ndra include');

INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(65536,2,'eng','Edit texts');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(65536,5,'eng','Edit');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(65536,6,'eng','Edit');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(65536,7,'eng','Edit');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(65536,8,'eng','Edit');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(65536,101,'eng','Edit');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(65536,102,'eng','Edit');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(131072,2,'eng','Edit pictures');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(262144,2,'eng','Edit menus');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(524288,2,'eng','Change template');
INSERT INTO doc_permissions (permission_id, doc_type, lang_prefix, description) VALUES(1048576,2,'eng','Change include');

INSERT INTO permissions (permission_id, lang_prefix, description) VALUES(1,'swe','ndra rubrik');
INSERT INTO permissions (permission_id, lang_prefix, description) VALUES(2,'swe','ndra dokinfo');
INSERT INTO permissions (permission_id, lang_prefix, description) VALUES(4,'swe','ndra rttigheter fr roller');
INSERT INTO permissions (permission_id, lang_prefix, description) VALUES(8,'swe','Skapa dokument');

INSERT INTO permissions (permission_id, lang_prefix, description) VALUES(1,'eng','Edit headline');
INSERT INTO permissions (permission_id, lang_prefix, description) VALUES(2,'eng','Edit docinfo');
INSERT INTO permissions (permission_id, lang_prefix, description) VALUES(4,'eng','Edit permissions');
INSERT INTO permissions (permission_id, lang_prefix, description) VALUES(8,'eng','Create document');

INSERT INTO permission_sets (set_id, description) VALUES(0,'Full');
INSERT INTO permission_sets (set_id, description) VALUES(1,'Begrnsad 1');
INSERT INTO permission_sets (set_id, description) VALUES(2,'Begrnsad 2');
INSERT INTO permission_sets (set_id, description) VALUES(3,'Ls');

INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(1,'Internet Explorer','%MSIE%',2);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(2,'Netscape','Mozilla%(%;%[UIN][);]%',2);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(3,'Internet Explorer 3','%MSIE 3%',4);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(4,'Internet Explorer 4','%MSIE 4%',4);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(5,'Internet Explorer 5','%MSIE 5%',4);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(6,'Internet Explorer 6','%MSIE 6%',4);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(7,'Netscape 3','Mozilla/3%(%;%[UIN][ );]%',4);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(8,'Netscape 4','Mozilla/4%(%;%[UIN][ );]%',4);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(9,'Netscape 6','Mozilla/5%(%;%[UIN][ );]%',4);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(10,'Netscape 7','Mozilla%/5;%netscape/7%',4);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(11,'Windows','%win%',1);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(12,'Macintosh','%mac%',1);

INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(13,'Windows Internet Explorer','%MSIE%win%',3);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(14,'Windows Internet Explorer 3','%MSIE 3%win%',5);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(15,'Windows Internet Explorer 4','%MSIE 4%win%',5);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(16,'Windows Internet Explorer 5.0','%MSIE 5.0%win%',5);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(17,'Windows Internet Explorer 5.5','%MSIE 5.5%win%',5);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(18,'Windows Internet Explorer 6','%MSIE 6%win%',5);

INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(19,'Windows Netscape','Mozilla%(%win%;%[UIN][ );]%',3);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(20,'Windows Netscape 3','Mozilla/3%(%win%;%[UIN][ );]%',5);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(21,'Windows Netscape 4','Mozilla/4%(%win%;%[UIN][ );]%',5);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(22,'Windows Netscape 6','Mozilla/5%(%win%;%[UIN][ );]%',5);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(23,'Windows Netscape 7','Mozilla/5%(%win%netscape/7%',5);

INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(24,'Macintosh Internet Explorer','%MSIE%mac%',3);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(25,'Macintosh Internet Explorer 3','%MSIE 3%mac%',5);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(26,'Macintosh Internet Explorer 4','%MSIE 4%mac%',5);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(27,'Macintosh Internet Explorer 5','%MSIE 5%mac%',5);

INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(28,'Macintosh Netscape','Mozilla%(%mac%;%[UIN][ );]%',3);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(29,'Macintosh Netscape 3','Mozilla/3%(%mac%;%[UIN][ );]%',5);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(30,'Macintosh Netscape 4','Mozilla/4%(%mac%;%[UIN][ );]%',5);
INSERT INTO browsers (browser_id, name, user_agent, value) VALUES(31,'Macintosh Netscape 6','Mozilla/5%(%mac%;%[UIN][ );]%',5);

INSERT INTO sys_types (type_id,name) VALUES(0,'StartDocument');
INSERT INTO sys_types (type_id,name) VALUES(1,'SessionCounter');
INSERT INTO sys_types (type_id,name) VALUES(2,'SessionCounterDate');
INSERT INTO sys_types (type_id,name) VALUES(3,'SystemMessage');
INSERT INTO sys_types (type_id,name) VALUES(4,'ServerMaster');
INSERT INTO sys_types (type_id,name) VALUES(5,'ServerMasterAddress');
INSERT INTO sys_types (type_id,name) VALUES(6,'WebMaster');
INSERT INTO sys_types (type_id,name) VALUES(7,'WebMasterAddress');

INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(0,'Annan...','other','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(1,'Vanlig text','text/plain','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(2,'HTML-dokument','text/html','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(3,'Binrfil','application/octet-stream','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(4,'Shockwave Flash','application/x-shockwave-flash','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(5,'Shockwave Director','application/x-director','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(6,'PNG-bild','image/png','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(7,'GIF-bild','image/gif','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(8,'JPEG-bild','image/jpeg','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(9,'Adobe Acrobat-dokument','application/pdf','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(10,'Wav-ljud','audio/x-wav','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(11,'Zip-fil','application/zip','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(12,'AVI-film','video/x-msvideo','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(13,'Quicktime-film','video/quicktime','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(14,'MPEG-film','video/mpeg','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(15,'MS Word-dokument','application/msword','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(16,'MS Excel-dokument','application/vnd.ms-excel','swe');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(17,'MS Powerpoint-dokument','application/vnd.ms-powerpoint','swe');

INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(0,'Other...','other','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(1,'Plain text','text/plain','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(2,'HTML-document','text/html','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(3,'Binary file','application/octet-stream','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(4,'Shockwave Flash','application/x-shockwave-flash','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(5,'Shockwave Director','application/x-director','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(6,'PNG-image','image/png','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(7,'GIF-image','image/gif','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(8,'JPEG-image','image/jpeg','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(9,'Adobe Acrobat-document','application/pdf','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(10,'Wav-sound','audio/x-wav','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(11,'Zip-file','application/zip','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(12,'AVI-movie','video/x-msvideo','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(13,'Quicktime-movie','video/quicktime','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(14,'MPEG-movie','video/mpeg','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(15,'MS Word-document','application/msword','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(16,'MS Excel-document','application/vnd.ms-excel','eng');
INSERT INTO mime_types (mime_id, mime_name, mime, lang_prefix) VALUES(17,'MS Powerpoint-document','application/vnd.ms-powerpoint','eng');

INSERT INTO phonetypes VALUES(0, 'Annat', 1 );
INSERT INTO phonetypes VALUES(1, 'Bostad', 1 );
INSERT INTO phonetypes VALUES(2, 'Arbete', 1 );
INSERT INTO phonetypes VALUES(3, 'Mobil', 1 );
INSERT INTO phonetypes VALUES(4, 'Fax', 1 );
INSERT INTO phonetypes VALUES(0, 'Other', 2 );
INSERT INTO phonetypes VALUES(1, 'Home', 2 );
INSERT INTO phonetypes VALUES(2, 'Work', 2 );
INSERT INTO phonetypes VALUES(3, 'Mobile', 2 );
INSERT INTO phonetypes VALUES(4, 'Fax', 2 );
SET IDENTITY_INSERT sys_data ON
INSERT INTO sys_data (sys_id, type_id, value) VALUES(0, 0, 1001);
INSERT INTO sys_data (sys_id, type_id, value) VALUES(1, 1, 0);
INSERT INTO sys_data (sys_id, type_id, value) VALUES(2, 2,

CONVERT(CHAR(10),GETDATE(),120)
);
INSERT INTO sys_data (sys_id, type_id, value) VALUES(3, 3, '');
INSERT INTO sys_data (sys_id, type_id, value) VALUES(4, 4, '');
INSERT INTO sys_data (sys_id, type_id, value) VALUES(5, 5, '');
INSERT INTO sys_data (sys_id, type_id, value) VALUES(6, 6, '');
INSERT INTO sys_data (sys_id, type_id, value) VALUES(7, 7, '');
SET IDENTITY_INSERT sys_data OFF

SET IDENTITY_INSERT users ON
INSERT INTO users (user_id, login_name, login_password, first_name, last_name,
                   title, company, address, city, zip, country, county_council, email,
                   external, active, create_date, language)
VALUES (1,'admin', 'admin', 'Admin', 'Super','','','','','','','','',0,1,

GETDATE()
,'swe');
INSERT INTO users (user_id, login_name, login_password, first_name, last_name,
                   title, company, address, city, zip, country, county_council, email,
                   external, active, create_date, language)
VALUES (2,'user', 'user', 'User', 'Extern','','','','','','','','',0,1,

GETDATE()
,'swe');
SET IDENTITY_INSERT users OFF

SET IDENTITY_INSERT roles ON
INSERT INTO roles (role_id, role_name, permissions, admin_role) VALUES(0, 'Superadmin', 0, 1);
INSERT INTO roles (role_id, role_name, permissions, admin_role) VALUES(1, 'Useradmin', 0, 2);
INSERT INTO roles (role_id, role_name, permissions, admin_role) VALUES(2, 'Users', 1, 0);
SET IDENTITY_INSERT roles OFF

INSERT INTO user_roles_crossref VALUES(1,0);
INSERT INTO user_roles_crossref VALUES(2,2);

SET IDENTITY_INSERT meta ON
INSERT INTO meta (meta_id, doc_type, meta_headline,                meta_text, meta_image, owner_id, permissions, shared, show_meta, lang_prefix,         date_created,                    date_modified,                   disable_search, archived_datetime, target,  activate, status, publication_start_datetime,      publication_end_datetime)
 VALUES (1001,   2,        'Startsidan',  '',        '',         1,        0,           0,      0,         'swe',

GETDATE()
,

GETDATE()
, 0,              null,              '_self', 1,        2,

GETDATE()
, null);
SET IDENTITY_INSERT meta OFF

INSERT INTO templates VALUES (1,'demo.html', 'demo', 'swe', 1,1,1);

SET IDENTITY_INSERT templategroups ON
INSERT INTO templategroups (group_id, group_name) VALUES (0, 'normal');
SET IDENTITY_INSERT templategroups OFF

INSERT INTO templates_cref VALUES(0,1);

INSERT INTO text_docs VALUES (1001, 1, 0, -1, -1, NULL);

INSERT INTO roles_rights VALUES (2,1001,3);

INSERT INTO texts (meta_id, name, text, type) VALUES( 1001, 1, '<h3>Vlkommen till imCMS</h3>',1);
INSERT INTO texts (meta_id, name, text, type) VALUES( 1001, 2, '<a href="<?imcms:contextpath?>/login/" title="Lnk till inloggningssida"><b>Logga in!</b></a><br><br><br><a href="<?imcms:contextpath?>/servlet/SearchDocuments" target="_blank" title="Lnk till sksida"><b>Sksida</b></a><br>ppnas i nytt fnster.<br><br><a href="http://doc.imcms.net/3.1.2/" target="_blank" title="Lnk till dokumentationssajt"><b>Dokumentation</b></a><br>Extern sajt, ppnas i nytt fnster.<br><br><a href="http://www.imcms.net" target="_blank" title="Lnk till www.imcms.net"><b>Mer om imCMS</b></a><br>Produktsajt om imCMS. Extern sajt, ppnas i nytt fnster.<br><br><a href="<?imcms:contextpath?>/imcms/docs/" target="_blank" title="Lnk till medfljande dokumentation."><b>Medfljande dokumentation</b></a><br>Fr administratrer och utvecklare, p engelska. ppnas i nytt fnster.<br><br><a href="<?imcms:contextpath?>/imcms/docs/apisamples/" target="_blank" title="Lnk till API-exempel"><b>API-exempel</b></a><br>Endast fr utvecklare, p engelska. ppnas i nytt fnster.<br>OBS! Endast fr testmilj - anvnd inte p publika sajter.',1);

INSERT INTO images ( meta_id , width , height , border , v_space , h_space , name , image_name , target , align , alt_text , low_scr , imgurl , linkurl, type )
values (1001,0,0,0,0,0,3,'','_blank','top','','','imCMSpower.gif','http://www.imcms.net','0');
