package org.apache.ddlutils.io;

/*
 * Copyright 1999-2005 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.commons.lang.exception.NestableRuntimeException;

/**
 * Exception generated by {@link org.apache.ddlutils.io.DataSink} implementations.
 * 
 * @author Thomas Dudziak
 * @version $Revision: 289996 $
 */
public class DataSinkException extends NestableRuntimeException
{
    /** Unique id for serialization purposes. */
    private static final long serialVersionUID = 6790909409839782437L;

    /**
     * Creates a new exception object.
     */
    public DataSinkException()
    {
        super();
    }

    /**
     * Creates a new exception object.
     * 
     * @param message The exception message
     */
    public DataSinkException(String message)
    {
        super(message);
    }

    /**
     * Creates a new exception object.
     * 
     * @param baseEx The base exception
     */
    public DataSinkException(Throwable baseEx)
    {
        super(baseEx);
    }

    /**
     * Creates a new exception object.
     * 
     * @param message The exception message
     * @param baseEx  The base exception
     */
    public DataSinkException(String message, Throwable baseEx)
    {
        super(message, baseEx);
    }
}
