/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.filters.CSVFilter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SuppressElement
implements Filter {
    private static final int HASH_MULT = 29;
    private Pattern mFileRegexp;
    private String mFilePattern;
    private Pattern mCheckRegexp;
    private String mCheckPattern;
    private CSVFilter mLineFilter;
    private String mLinesCSV;
    private CSVFilter mColumnFilter;
    private String mColumnsCSV;

    public SuppressElement(String aFiles, String aChecks) throws PatternSyntaxException {
        this.mFilePattern = aFiles;
        this.mFileRegexp = Utils.getPattern(aFiles);
        this.mCheckPattern = aChecks;
        this.mCheckRegexp = Utils.getPattern(aChecks);
    }

    public void setLines(String aLines) {
        this.mLinesCSV = aLines;
        this.mLineFilter = aLines != null ? new CSVFilter(aLines) : null;
    }

    public void setColumns(String aColumns) {
        this.mColumnsCSV = aColumns;
        this.mColumnFilter = aColumns != null ? new CSVFilter(aColumns) : null;
    }

    public boolean accept(AuditEvent aEvent) {
        Integer column;
        Integer line;
        if (aEvent.getFileName() == null || !this.mFileRegexp.matcher(aEvent.getFileName()).find() || aEvent.getLocalizedMessage() == null || !this.mCheckRegexp.matcher(aEvent.getSourceName()).find()) {
            return true;
        }
        if (this.mLineFilter == null && this.mColumnFilter == null) {
            return false;
        }
        if (this.mLineFilter != null && this.mLineFilter.accept(line = new Integer(aEvent.getLine()))) {
            return false;
        }
        return this.mColumnFilter == null || !this.mColumnFilter.accept(column = new Integer(aEvent.getColumn()));
    }

    public String toString() {
        return "SupressElement[files=" + this.mFilePattern + ",checks=" + this.mCheckPattern + ",lines=" + this.mLinesCSV + ",columns=" + this.mColumnsCSV + "]";
    }

    public int hashCode() {
        int result = 29 * this.mFilePattern.hashCode() + this.mCheckPattern.hashCode();
        if (this.mLinesCSV != null) {
            result = 29 * result + this.mLinesCSV.hashCode();
        }
        if (this.mColumnsCSV != null) {
            result = 29 * result + this.mColumnsCSV.hashCode();
        }
        return result;
    }

    public boolean equals(Object aObject) {
        if (aObject instanceof SuppressElement) {
            SuppressElement other = (SuppressElement)aObject;
            if (!this.mFilePattern.equals(other.mFilePattern)) {
                return false;
            }
            if (!this.mCheckPattern.equals(other.mCheckPattern)) {
                return false;
            }
            if (this.mLineFilter != null ? !this.mLineFilter.equals(other.mLineFilter) : other.mLineFilter != null) {
                return false;
            }
            return !(this.mColumnFilter != null ? !this.mColumnFilter.equals(other.mColumnFilter) : other.mColumnFilter != null);
        }
        return false;
    }
}

