/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;

public class MethodParamPadCheck
extends AbstractOptionCheck {
    private boolean mAllowLineBreaks;

    public MethodParamPadCheck() {
        super(PadOption.NOSPACE);
    }

    public int[] getDefaultTokens() {
        return new int[]{8, 136, 27, 9, 42};
    }

    public void visitToken(DetailAST aAST) {
        DetailAST parenAST;
        if (aAST.getType() == 27) {
            parenAST = aAST;
        } else {
            parenAST = aAST.findFirstToken(76);
            if (parenAST == null) {
                return;
            }
        }
        int parenColumnNo = parenAST.getColumnNo();
        String[] lines = this.getLines();
        int identLineNo = -1;
        int identColumnNo = -1;
        DetailAST dotAST = aAST.findFirstToken(59);
        DetailAST identAST = dotAST != null ? dotAST.getLastChild() : (aAST.getType() == 42 ? aAST : aAST.findFirstToken(58));
        identLineNo = identAST.getLineNo();
        identColumnNo = identAST.getColumnNo();
        String identText = identAST.getText();
        if (identLineNo == parenAST.getLineNo()) {
            int after = identColumnNo + identText.length();
            String line = lines[identLineNo - 1];
            if (PadOption.NOSPACE == this.getAbstractOption() && Character.isWhitespace(line.charAt(after))) {
                this.log(identLineNo, after, "ws.followed", (Object)identText);
            } else if (PadOption.SPACE == this.getAbstractOption() && !Character.isWhitespace(line.charAt(after))) {
                this.log(identLineNo, after, "ws.notFollowed", (Object)identText);
            }
        } else if (!this.mAllowLineBreaks) {
            this.log(parenAST.getLineNo(), parenColumnNo, "line.previous", (Object)parenAST.getText());
        }
    }

    public void setAllowLineBreaks(boolean aAllowLineBreaks) {
        this.mAllowLineBreaks = aAllowLineBreaks;
    }
}

