/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.HtmlTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.TagParser;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class JavadocStyleCheck
extends Check {
    private static final String UNCLOSED_HTML = "javadoc.unclosedhtml";
    private static final String EXTRA_HTML = "javadoc.extrahtml";
    private static final String[] SINGLE_TAG = new String[]{"p", "br", "li", "dt", "dd", "td", "hr", "img", "tr", "th", "td"};
    private Scope mScope = Scope.PRIVATE;
    private Scope mExcludeScope;
    private Pattern mEndOfSentencePattern;
    private boolean mCheckFirstSentence = true;
    private boolean mCheckHtml = true;
    private boolean mCheckEmptyJavadoc;

    public int[] getDefaultTokens() {
        return new int[]{15, 14, 157, 154, 9, 8, 10, 155, 161};
    }

    public void visitToken(DetailAST aAST) {
        if (this.shouldCheck(aAST)) {
            FileContents contents = this.getFileContents();
            TextBlock cmt = contents.getJavadocBefore(aAST.getLineNo());
            this.checkComment(aAST, cmt);
        }
    }

    private boolean shouldCheck(DetailAST aAST) {
        if (ScopeUtils.inCodeBlock(aAST)) {
            return false;
        }
        Scope declaredScope = aAST.getType() == 155 ? Scope.PUBLIC : ScopeUtils.getScopeFromMods(aAST.findFirstToken(5));
        Scope scope = ScopeUtils.inInterfaceOrAnnotationBlock(aAST) ? Scope.PUBLIC : declaredScope;
        Scope surroundingScope = ScopeUtils.getSurroundingScope(aAST);
        return scope.isIn(this.mScope) && (surroundingScope == null || surroundingScope.isIn(this.mScope)) && (this.mExcludeScope == null || !scope.isIn(this.mExcludeScope) || surroundingScope != null && !surroundingScope.isIn(this.mExcludeScope));
    }

    private void checkComment(DetailAST aAST, TextBlock aComment) {
        if (aComment == null) {
            return;
        }
        if (this.mCheckFirstSentence) {
            this.checkFirstSentence(aComment);
        }
        if (this.mCheckHtml) {
            this.checkHtml(aAST, aComment);
        }
        if (this.mCheckEmptyJavadoc) {
            this.checkEmptyJavadoc(aComment);
        }
    }

    private void checkFirstSentence(TextBlock aComment) {
        String commentText = this.getCommentText(aComment.getText());
        if (commentText.length() != 0 && !this.getEndOfSentencePattern().matcher(commentText).find() && !"{@inheritDoc}".equals(commentText)) {
            this.log(aComment.getStartLineNo(), "javadoc.noperiod");
        }
    }

    private void checkEmptyJavadoc(TextBlock aComment) {
        String commentText = this.getCommentText(aComment.getText());
        if (commentText.length() == 0) {
            this.log(aComment.getStartLineNo(), "javadoc.empty");
        }
    }

    private String getCommentText(String[] aComments) {
        StringBuffer buffer = new StringBuffer();
        boolean foundTag = false;
        for (int i = 0; i < aComments.length; ++i) {
            String line = aComments[i];
            int textStart = this.findTextStart(line);
            if (textStart == -1) continue;
            int ndx = line.indexOf(64);
            if (ndx != -1 && (ndx == 0 || line.charAt(ndx - 1) != '{')) {
                foundTag = true;
                line = line.substring(0, ndx);
            }
            buffer.append(line.substring(textStart));
            this.trimTail(buffer);
            buffer.append('\n');
            if (foundTag) break;
        }
        return buffer.toString().trim();
    }

    private int findTextStart(String aLine) {
        int textStart = -1;
        for (int i = 0; i < aLine.length(); ++i) {
            if (Character.isWhitespace(aLine.charAt(i))) continue;
            if (aLine.regionMatches(i, "/**", 0, "/**".length())) {
                i += 2;
                continue;
            }
            if (aLine.regionMatches(i, "*/", 0, 2)) {
                ++i;
                continue;
            }
            if (aLine.charAt(i) == '*') continue;
            textStart = i;
            break;
        }
        return textStart;
    }

    private void trimTail(StringBuffer aBuffer) {
        for (int i = aBuffer.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(aBuffer.charAt(i))) {
                aBuffer.deleteCharAt(i);
                continue;
            }
            if (i <= 0 || aBuffer.charAt(i - 1) != '*' || aBuffer.charAt(i) != '/') break;
            aBuffer.deleteCharAt(i);
            aBuffer.deleteCharAt(i - 1);
            --i;
        }
    }

    private void checkHtml(DetailAST aAST, TextBlock aComment) {
        int lineno = aComment.getStartLineNo();
        Stack<HtmlTag> htmlStack = new Stack<HtmlTag>();
        String[] text = aComment.getText();
        List typeParameters = CheckUtils.getTypeParameterNames(aAST);
        TagParser parser = null;
        parser = new TagParser(text, lineno);
        while (parser.hasNextTag()) {
            HtmlTag tag = parser.nextTag();
            if (tag.isIncompleteTag()) {
                this.log(tag.getLineno(), "javadoc.incompleteTag", new Object[]{text[tag.getLineno() - lineno]});
                return;
            }
            if (tag.isClosedTag()) continue;
            if (!tag.isCloseTag()) {
                htmlStack.push(tag);
                continue;
            }
            if (this.isExtraHtml(tag.getId(), htmlStack)) {
                this.log(tag.getLineno(), tag.getPosition(), EXTRA_HTML, (Object)tag);
                continue;
            }
            this.checkUnclosedTags(htmlStack, tag.getId());
        }
        String lastFound = "";
        for (int i = 0; i < htmlStack.size(); ++i) {
            HtmlTag htag = (HtmlTag)htmlStack.elementAt(i);
            if (this.isSingleTag(htag) || htag.getId().equals(lastFound) || typeParameters.contains(htag.getId())) continue;
            this.log(htag.getLineno(), htag.getPosition(), UNCLOSED_HTML, (Object)htag);
            lastFound = htag.getId();
        }
    }

    private void checkUnclosedTags(Stack aHtmlStack, String aToken) {
        Stack<HtmlTag> unclosedTags = new Stack<HtmlTag>();
        HtmlTag lastOpenTag = (HtmlTag)aHtmlStack.pop();
        while (!aToken.equalsIgnoreCase(lastOpenTag.getId())) {
            if (this.isSingleTag(lastOpenTag)) {
                lastOpenTag = (HtmlTag)aHtmlStack.pop();
                continue;
            }
            unclosedTags.push(lastOpenTag);
            lastOpenTag = (HtmlTag)aHtmlStack.pop();
        }
        String lastFound = "";
        for (int i = 0; i < unclosedTags.size(); ++i) {
            lastOpenTag = (HtmlTag)unclosedTags.get(i);
            if (lastOpenTag.getId().equals(lastFound)) continue;
            lastFound = lastOpenTag.getId();
            this.log(lastOpenTag.getLineno(), lastOpenTag.getPosition(), UNCLOSED_HTML, (Object)lastOpenTag);
        }
    }

    private boolean isSingleTag(HtmlTag aTag) {
        boolean isSingleTag = false;
        for (int i = 0; i < SINGLE_TAG.length; ++i) {
            if (!aTag.getId().equalsIgnoreCase(SINGLE_TAG[i])) continue;
            isSingleTag = true;
        }
        return isSingleTag;
    }

    private boolean isExtraHtml(String aToken, Stack aHtmlStack) {
        boolean isExtra = true;
        for (int i = 0; i < aHtmlStack.size(); ++i) {
            HtmlTag td = (HtmlTag)aHtmlStack.elementAt(i);
            if (!aToken.equalsIgnoreCase(td.getId())) continue;
            isExtra = false;
            break;
        }
        return isExtra;
    }

    public void setScope(String aFrom) {
        this.mScope = Scope.getInstance(aFrom);
    }

    public void setExcludeScope(String aScope) {
        this.mExcludeScope = Scope.getInstance(aScope);
    }

    private Pattern getEndOfSentencePattern() {
        if (this.mEndOfSentencePattern == null) {
            try {
                this.mEndOfSentencePattern = Pattern.compile("([.?!][ \t\n\r\f<])|([.?!]$)");
            }
            catch (PatternSyntaxException e) {
                e.printStackTrace();
            }
        }
        return this.mEndOfSentencePattern;
    }

    public void setCheckFirstSentence(boolean aFlag) {
        this.mCheckFirstSentence = aFlag;
    }

    public void setCheckHtml(boolean aFlag) {
        this.mCheckHtml = aFlag;
    }

    public void setCheckEmptyJavadoc(boolean aFlag) {
        this.mCheckEmptyJavadoc = aFlag;
    }
}

