/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.checks.imports.AccessResult;
import com.puppycrawl.tools.checkstyle.checks.imports.Guard;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class PkgControl {
    private final LinkedList mGuards = new LinkedList();
    private final List mChildren = new ArrayList();
    private final PkgControl mParent;
    private final String mFullPackage;
    static final /* synthetic */ boolean $assertionsDisabled;

    PkgControl(String aPkgName) {
        if (!$assertionsDisabled && aPkgName == null) {
            throw new AssertionError();
        }
        this.mParent = null;
        this.mFullPackage = aPkgName;
    }

    PkgControl(PkgControl aParent, String aSubPkg) {
        if (!$assertionsDisabled && aParent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && aSubPkg == null) {
            throw new AssertionError();
        }
        this.mParent = aParent;
        this.mFullPackage = aParent.getFullPackage() + "." + aSubPkg;
        this.mParent.mChildren.add(this);
    }

    void addGuard(Guard aThug) {
        this.mGuards.addFirst(aThug);
    }

    String getFullPackage() {
        return this.mFullPackage;
    }

    PkgControl locateFinest(String aForPkg) {
        if (!aForPkg.startsWith(this.getFullPackage())) {
            return null;
        }
        Iterator it = this.mChildren.iterator();
        while (it.hasNext()) {
            PkgControl pc = (PkgControl)it.next();
            PkgControl match = pc.locateFinest(aForPkg);
            if (match == null) continue;
            return match;
        }
        return this;
    }

    AccessResult checkAccess(String aForImport, String aInPkg) {
        AccessResult retVal = this.localCheckAccess(aForImport, aInPkg);
        if (retVal != AccessResult.UNKNOWN) {
            return retVal;
        }
        if (this.mParent == null) {
            return AccessResult.DISALLOWED;
        }
        return this.mParent.checkAccess(aForImport, aInPkg);
    }

    private AccessResult localCheckAccess(String aForImport, String aInPkg) {
        Iterator it = this.mGuards.iterator();
        while (it.hasNext()) {
            AccessResult result;
            Guard g = (Guard)it.next();
            if (g.isLocalOnly() && !this.mFullPackage.equals(aInPkg) || (result = g.verifyImport(aForImport, aInPkg)) == AccessResult.UNKNOWN) continue;
            return result;
        }
        return AccessResult.UNKNOWN;
    }

    static {
        $assertionsDisabled = !PkgControl.class.desiredAssertionStatus();
    }
}

