/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.AbstractLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.checks.imports.Guard;
import com.puppycrawl.tools.checkstyle.checks.imports.PkgControl;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class ImportControlLoader
extends AbstractLoader {
    private static final String DTD_PUBLIC_ID = "-//Puppy Crawl//DTD Import Control 1.0//EN";
    private static final String DTD_RESOURCE_NAME = "com/puppycrawl/tools/checkstyle/checks/imports/import_control_1_0.dtd";
    private Stack mStack = new Stack();
    static final /* synthetic */ boolean $assertionsDisabled;

    private ImportControlLoader() throws ParserConfigurationException, SAXException {
        super(DTD_PUBLIC_ID, DTD_RESOURCE_NAME);
    }

    public void startElement(String aNamespaceURI, String aLocalName, String aQName, Attributes aAtts) throws SAXException {
        if (aQName.equals("import-control")) {
            String pkg = this.safeGet(aAtts, "pkg");
            this.mStack.push(new PkgControl(pkg));
        } else if (aQName.equals("subpackage")) {
            if (!$assertionsDisabled && this.mStack.size() <= 0) {
                throw new AssertionError();
            }
            String name = this.safeGet(aAtts, "name");
            this.mStack.push(new PkgControl((PkgControl)this.mStack.peek(), name));
        } else if (aQName.equals("allow") || aQName.equals("disallow")) {
            Guard g;
            if (!$assertionsDisabled && this.mStack.size() <= 0) {
                throw new AssertionError();
            }
            boolean isAllow = aQName.equals("allow");
            boolean isLocalOnly = aAtts.getValue("local-only") != null;
            String pkg = aAtts.getValue("pkg");
            if (pkg != null) {
                boolean exactMatch = aAtts.getValue("exact-match") != null;
                g = new Guard(isAllow, isLocalOnly, pkg, exactMatch);
            } else {
                String clazz = this.safeGet(aAtts, "class");
                g = new Guard(isAllow, isLocalOnly, clazz);
            }
            PkgControl pc = (PkgControl)this.mStack.peek();
            pc.addGuard(g);
        }
    }

    public void endElement(String aNamespaceURI, String aLocalName, String aQName) {
        if (aQName.equals("subpackage")) {
            if (!$assertionsDisabled && this.mStack.size() <= 2) {
                throw new AssertionError();
            }
            this.mStack.pop();
        }
    }

    static PkgControl load(String aFilename) throws CheckstyleException {
        FileReader reader = null;
        try {
            reader = new FileReader(aFilename);
        }
        catch (FileNotFoundException e) {
            throw new CheckstyleException("unable to find " + aFilename, e);
        }
        InputSource source = new InputSource(reader);
        return ImportControlLoader.load(source, aFilename);
    }

    private static PkgControl load(InputSource aSource, String aSourceName) throws CheckstyleException {
        try {
            ImportControlLoader loader = new ImportControlLoader();
            loader.parseInputSource(aSource);
            return loader.getRoot();
        }
        catch (ParserConfigurationException e) {
            throw new CheckstyleException("unable to parse " + aSourceName, e);
        }
        catch (SAXException e) {
            throw new CheckstyleException("unable to parse " + aSourceName + " - " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CheckstyleException("unable to read " + aSourceName, e);
        }
    }

    private PkgControl getRoot() {
        if (!$assertionsDisabled && this.mStack.size() != 1) {
            throw new AssertionError();
        }
        return (PkgControl)this.mStack.peek();
    }

    private String safeGet(Attributes aAtts, String aName) throws SAXException {
        String retVal = aAtts.getValue(aName);
        if (retVal == null) {
            throw new SAXException("missing attibute " + aName);
        }
        return retVal;
    }

    static {
        $assertionsDisabled = !ImportControlLoader.class.desiredAssertionStatus();
    }
}

