/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.AbstractTypeAwareCheck;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RedundantThrowsCheck
extends AbstractTypeAwareCheck {
    private boolean mAllowUnchecked;
    private boolean mAllowSubclasses;

    public void setAllowUnchecked(boolean aAllowUnchecked) {
        this.mAllowUnchecked = aAllowUnchecked;
    }

    public void setAllowSubclasses(boolean aAllowSubclasses) {
        this.mAllowSubclasses = aAllowSubclasses;
    }

    public int[] getDefaultTokens() {
        return new int[]{16, 30, 14, 154, 9, 8};
    }

    protected final void processAST(DetailAST aAST) {
        LinkedList knownExcs = new LinkedList();
        DetailAST throwsAST = aAST.findFirstToken(81);
        if (throwsAST != null) {
            for (DetailAST child = (DetailAST)throwsAST.getFirstChild(); child != null; child = (DetailAST)child.getNextSibling()) {
                if (child.getType() != 58 && child.getType() != 59) continue;
                FullIdent fi = FullIdent.createFullIdent(child);
                this.checkException(fi, knownExcs);
            }
        }
    }

    protected final void logLoadError(AbstractTypeAwareCheck.Token aIdent) {
        this.logLoadErrorImpl(aIdent.getLineNo(), aIdent.getColumnNo(), "redundant.throws.classInfo", new Object[]{aIdent.getText()});
    }

    private void checkException(FullIdent aExc, List aKnownExcs) {
        AbstractTypeAwareCheck.ClassInfo newClassInfo = this.createClassInfo(new AbstractTypeAwareCheck.Token(aExc), this.getCurrentClassName());
        if (!this.mAllowUnchecked && this.isUnchecked(newClassInfo.getClazz())) {
            this.log(aExc.getLineNo(), aExc.getColumnNo(), "redundant.throws.unchecked", (Object)aExc.getText());
        }
        boolean shouldAdd = true;
        Iterator known = aKnownExcs.iterator();
        while (known.hasNext()) {
            AbstractTypeAwareCheck.ClassInfo ci = (AbstractTypeAwareCheck.ClassInfo)known.next();
            AbstractTypeAwareCheck.Token fi = ci.getName();
            if (this.isSameType(fi.getText(), aExc.getText())) {
                shouldAdd = false;
                this.log(aExc.getLineNo(), aExc.getColumnNo(), "redundant.throws.duplicate", (Object)aExc.getText());
                continue;
            }
            if (this.mAllowSubclasses) continue;
            if (this.isSubclass(ci.getClazz(), newClassInfo.getClazz())) {
                known.remove();
                this.log(fi.getLineNo(), fi.getColumnNo(), "redundant.throws.subclass", fi.getText(), aExc.getText());
                continue;
            }
            if (!this.isSubclass(newClassInfo.getClazz(), ci.getClazz())) continue;
            shouldAdd = false;
            this.log(aExc.getLineNo(), aExc.getColumnNo(), "redundant.throws.subclass", aExc.getText(), fi.getText());
        }
        if (shouldAdd) {
            aKnownExcs.add(newClassInfo);
        }
    }
}

