/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractOption;
import com.puppycrawl.tools.checkstyle.checks.LineSeparatorOption;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.beanutils.ConversionException;

public class NewlineAtEndOfFileCheck
extends AbstractFileSetCheck {
    private LineSeparatorOption mLineSeparator = LineSeparatorOption.SYSTEM;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(File[] aFiles) {
        File[] files = this.filter(aFiles);
        MessageDispatcher dispatcher = this.getMessageDispatcher();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String path = file.getPath();
            dispatcher.fireFileStarted(path);
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
                if (!this.endsWithNewline(randomAccessFile)) {
                    this.log(0, "noNewlineAtEOF", (Object)path);
                }
            }
            catch (IOException e) {
                this.logIOException(e);
            }
            finally {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException e) {
                        this.logIOException(e);
                    }
                }
            }
            this.fireErrors(path);
            dispatcher.fireFileFinished(path);
        }
    }

    public void setLineSeparator(String aLineSeparator) {
        AbstractOption option = LineSeparatorOption.SYSTEM.decode(aLineSeparator);
        if (option == null) {
            throw new ConversionException("unable to parse " + aLineSeparator);
        }
        this.mLineSeparator = (LineSeparatorOption)option;
    }

    private boolean endsWithNewline(RandomAccessFile aRandomAccessFile) throws IOException {
        int len = this.mLineSeparator.length();
        if (aRandomAccessFile.length() < (long)len) {
            return false;
        }
        aRandomAccessFile.seek(aRandomAccessFile.length() - (long)len);
        byte[] lastBytes = new byte[len];
        aRandomAccessFile.read(lastBytes);
        return this.mLineSeparator.matches(lastBytes);
    }

    private void logIOException(IOException aEx) {
        Object[] args = null;
        String key = "general.fileNotFound";
        if (!(aEx instanceof FileNotFoundException)) {
            args = new String[]{aEx.getMessage()};
            key = "general.exception";
        }
        LocalizedMessage message = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", key, args, this.getClass());
        this.getMessageCollector().add(message);
        Utils.getExceptionLogger().debug((Object)"IOException occured.", (Throwable)aEx);
    }
}

