/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import java.util.Iterator;
import java.util.Set;

public class ClassResolver {
    private final String mPkg;
    private final Set mImports;
    private final ClassLoader mLoader;

    public ClassResolver(ClassLoader aLoader, String aPkg, Set aImports) {
        this.mLoader = aLoader;
        this.mPkg = aPkg;
        this.mImports = aImports;
    }

    public Class resolve(String aName, String aCurrentClass) throws ClassNotFoundException {
        String innerClass;
        String fqn;
        String cn;
        if (this.isLoadable(aName)) {
            return this.safeLoad(aName);
        }
        int dotIdx = aName.lastIndexOf(".");
        if (dotIdx != -1 && this.isLoadable(cn = aName.substring(0, dotIdx) + "$" + aName.substring(dotIdx + 1))) {
            return this.safeLoad(cn);
        }
        Iterator it = this.mImports.iterator();
        while (it.hasNext()) {
            String innerName;
            String imp = (String)it.next();
            if (!imp.endsWith("." + aName)) continue;
            if (this.isLoadable(imp)) {
                return this.safeLoad(imp);
            }
            int dot = imp.lastIndexOf(".");
            if (dot == -1 || !this.isLoadable(innerName = imp.substring(0, dot) + "$" + imp.substring(dot + 1))) continue;
            return this.safeLoad(innerName);
        }
        if (!"".equals(this.mPkg) && this.isLoadable(fqn = this.mPkg + "." + aName)) {
            return this.safeLoad(fqn);
        }
        if (!"".equals(aCurrentClass) && this.isLoadable(innerClass = (!"".equals(this.mPkg) ? this.mPkg + "." : "") + aCurrentClass + "$" + aName)) {
            return this.safeLoad(innerClass);
        }
        String langClass = "java.lang." + aName;
        if (this.isLoadable(langClass)) {
            return this.safeLoad(langClass);
        }
        it = this.mImports.iterator();
        while (it.hasNext()) {
            String fqn2;
            String imp = (String)it.next();
            if (!imp.endsWith(".*") || !this.isLoadable(fqn2 = imp.substring(0, imp.lastIndexOf(46) + 1) + aName)) continue;
            return this.safeLoad(fqn2);
        }
        return this.safeLoad(aName);
    }

    public boolean isLoadable(String aName) {
        try {
            this.safeLoad(aName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Class safeLoad(String aName) throws ClassNotFoundException {
        return Class.forName(aName, false, this.mLoader);
    }
}

