/*
 * Decompiled with CFR 0.152.
 */
package com.codeczar.maven.tomcat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class InsertJspServlets {
    private static final Log LOG = LogFactory.getLog((String)("org.apache.maven." + InsertJspServlets.class.getName()));
    private File mSrcFile;
    private File mDestFile;
    private File mGeneratedWebXml;

    public void execute() {
        if (this.mSrcFile == null || !this.mSrcFile.isFile()) {
            throw new RuntimeException("The [srcfile] attribute is required");
        }
        if (this.mDestFile == null) {
            throw new RuntimeException("The [destfile] attribute is required");
        }
        try {
            String webXmlStr = InsertJspServlets.fileToString(this.mSrcFile);
            String generatedXml = InsertJspServlets.fileToString(this.mGeneratedWebXml);
            int insertIndex = -1;
            int searchIndex = 0;
            String[] elementTypes = new String[]{"</servlet>", "</listener>", "</filter-mapping>", "</filter>", "</context-param>", "</distributable>", "</icon>", "</display-name>", "</description>", "<web-app>"};
            StringBuffer sb = new StringBuffer(webXmlStr);
            while (searchIndex < 10 && insertIndex == -1) {
                insertIndex = webXmlStr.lastIndexOf(elementTypes[searchIndex]);
                if (insertIndex == -1) {
                    ++searchIndex;
                    continue;
                }
                sb.insert(insertIndex += elementTypes[searchIndex].length(), generatedXml);
            }
            if (searchIndex == 10) {
                throw new RuntimeException("" + elementTypes + " not found in web.xml");
            }
            FileWriter fw = new FileWriter(this.mDestFile);
            String mergedFile = sb.toString();
            fw.write(mergedFile);
            fw.flush();
            fw.close();
            LOG.debug((Object)("merged generated '" + this.mGeneratedWebXml + "' with '" + this.mDestFile + "'"));
        }
        catch (IOException ioe) {
            throw new RuntimeException("An I/O error occurred: " + ioe.getMessage(), ioe);
        }
    }

    private static String fileToString(File file) throws IOException {
        int insertIndex = -1;
        boolean searchIndex = false;
        StringBuffer sb = new StringBuffer();
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    public final void setSrcFile(File srcFile) {
        this.mSrcFile = srcFile;
    }

    public final void setDestFile(File destFile) {
        this.mDestFile = destFile;
    }

    public final void setGeneratedWebXml(File generatedWebXml) {
        this.mGeneratedWebXml = generatedWebXml;
    }
}

